#!/usr/bin/env python3
import os,sys,struct,math
import numpy as np

if len(sys.argv) != 5:
  print("Usage:")
  print("./applygacos.py inpfilename ztd1filename ztd2filename elevfilename")
  print("   inpfilenmae : input interferogram, a inpfilename.rsc is needed!")
  print("   ztd1filename: input GACOS ztd day1 filename, a ztd1filename.rsc is needed!")
  print("   ztd2filename: input GACOS ztd day2 filename, a ztd2filename.rsc is needed!")
  print("   elevfilename: elevation angle file, must be the same size with interferogram")
  print("                 elevation=90-incidence ")
  print("                 can be generated by look_vector in gamma")
  print("outputfile will be saved as inpfilename.gacos")
  print("!!Note, python3 is needed!!")
  exit()




filename=sys.argv[1]
ztd1filename=sys.argv[2]
ztd2filename=sys.argv[3]
elevfilename=sys.argv[4]
print("start processing "+ filename)

class HEADER:
    width = 0
    length = 0
    xfirst = 0.0
    yfirst = 0.0
    xstep = 0.0
    ystep = 0.0





def read_header(filename):
   if not os.path.isfile(filename):
      print(filename+" file not exit")
    
   header = HEADER()
   with open(filename) as f:
      for line in f:
         data=line.split() 
         if data[0] == "WIDTH":
              header.width=int(data[1])
         if data[0] == "FILE_LENGTH":
              header.length=int(data[1])
         if data[0] == "X_FIRST":
              header.xfirst=float(data[1])
         if data[0] == "Y_FIRST":
              header.yfirst=float(data[1])
         if data[0] == "X_STEP":
              header.xstep=float(data[1])
         if data[0] == "Y_STEP":
              header.ystep=float(data[1])

   return header


def cut_image2(filename,headername,yfirst_new,length_new,xfirst_new,width_new):
   header=read_header(headername)   

   #print(yfirst_new, header.yfirst)
   #print(length_new, header.length)
   #print(xfirst_new, header.xfirst)
   #print(width_new, header.width)

   with open(filename, 'rb') as f:
     data0 = np.fromfile(f, dtype=np.float32)
     data = np.reshape(data0, (header.length, header.width))
  
   
   out=np.zeros((length_new,width_new),dtype=np.float32)
   #out=np.zeros(width_new*length_new,dtype=np.float32)
   for i in range(header.length):
      lat=header.yfirst+header.ystep*i
      row=int(round((lat-yfirst_new)/header.ystep))
      if(row<0 or row>=length_new):
         continue
      for j in range(header.width):
        lon=header.xfirst+header.xstep*j
        col=int(round((lon-xfirst_new)/header.xstep))
        if(col<0 or col>=width_new):
            continue
        #out[width_new*row+col]=data[header.width*i+j]
        out[row,col]=data[i,j]

   out=np.where(out==0,np.nan,out)
   #print(np.nanstd(out))
   out.tofile(filename+".cut")
   f = open(filename+".cut.rsc", 'w')
   f.write("WIDTH "+str(width_new)+"\n")
   f.write("FILE_LENGTH "+str(length_new)+"\n")
   f.write("X_FIRST "+ str(xfirst_new)+"\n")
   f.write("Y_FIRST "+ str(yfirst_new)+"\n")
   f.write("X_STEP  "+ str(header.xstep)+"\n")
   f.write("Y_STEP  "+ str(header.ystep)+"\n")
   f.close()




def make_correction(phsfilename,ztd1filename,ztd2filename,elevfilename):
  header=read_header(phsfilename+".rsc")
  if not os.path.isfile(ztd1filename+".cut"):
     cut_image2(ztd1filename,ztd1filename+".rsc",header.yfirst,header.length,header.xfirst,header.width)
  if not os.path.isfile(ztd2filename+".cut"):
     cut_image2(ztd2filename,ztd2filename+".rsc",header.yfirst,header.length,header.xfirst,header.width)
  
  with open(phsfilename, 'rb') as f:
    data = np.fromfile(f, dtype=np.float32)
    phase = np.reshape(data, [header.length, header.width])

  with open(ztd1filename+".cut", 'rb') as f:
    data = np.fromfile(f, dtype=np.float32)
    ztd1 = np.reshape(data, [header.length, header.width])

  with open(ztd2filename+".cut", 'rb') as f:
    data = np.fromfile(f, dtype=np.float32)
    ztd2 = np.reshape(data, [header.length, header.width])

  with open(elevfilename, 'rb') as f:
    data = np.fromfile(f, dtype=np.float32)
    elev = np.reshape(data, [header.length, header.width])

  #os.remove(ztd1filename+".cut")
  #os.remove(ztd2filename+".cut") 
  dztd=ztd2-ztd1
  dztd=dztd/0.0044138251819503
  dztd=dztd/np.sin(elev)
  index=np.where(phase==0)
  phase[index]=np.nan
  phasemean=np.nanmean(phase)
  print("before "+str(np.nanstd(phase)))
  phase=phase-phasemean
  #phase.tofile(phsfilename+".raw")


  phase=phase-dztd
  phase[index]=np.nan
  phasemean=np.nanmean(phase)
  print("after "+str(np.nanstd(phase)))
  phase=phase-phasemean
  phase[index]=0
  phase.tofile(phsfilename+".gacos")



make_correction(filename,ztd1filename,ztd2filename,elevfilename)




exit()


